cd "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/"

global type tavg
global distance 2000
global adj_series "Without CRN"

*Run at least once to produce smaller versions of the files to reduce load times for each type
use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw.$type.dta", clear
keep if year >= 2004
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN raw small.$type.dta", replace

use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN $adj_series FLs.52j.$type.dta", clear
keep if year >= 2004
save "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j small.$type.dta", replace


use hcn_only_station_pairs_$distance.dta, clear

su station_pair_id
local max = r(max)

clear
tempfile results
cap gen date = 0
keep if _n < 0
sort date
save "`results'", replace

forvalues pair_id = 1(1)`max' {
	quietly {
	use hcn_only_station_pairs_$distance.dta, clear
	keep if station_pair_id == `pair_id'
	local station_id_1 = station_id_v1[1]
	local station_id_2 = station_id_v2[1]
	local distance = distance[1]
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j small.$type.dta", clear
	destring station_id, replace
	keep if station_id == `station_id_1'
	rename avg hcn_adj_1_$type
	keep hcn_adj_1_$type date
	drop if hcn_adj_1_$type == . | hcn_adj_1_$type == -9999
	sort date
	tempfile hcn_adj_1_results
	save "`hcn_adj_1_results'", replace
	
	use "/Users/hausfath/Desktop/Climate Science/CRN/CRN HCN Project/HCN Data/USHCN FLs.52j small.$type.dta", clear
	destring station_id, replace
	keep if station_id == `station_id_2'
	rename avg hcn_adj_2_$type
	keep hcn_adj_2_$type date
	drop if hcn_adj_2_$type == . | hcn_adj_2_$type == -9999
	sort date
	merge date using "`hcn_adj_1_results'"
	keep if _merge == 3
	drop _merge
	sort date	
	
	gen month = month(dofm(date))
	gen year = year(dofm(date))

	sort month	
	tempfile tempdata
	save "`tempdata'", replace

	collapse (mean) base_hcn_1=hcn_adj_1_$type base_hcn_2=hcn_adj_2_$type, by(month)
	sort month

	merge month using "`tempdata'"
	drop _merge
	replace hcn_adj_1_$type = hcn_adj_1_$type - base_hcn_1
	replace hcn_adj_2_$type = hcn_adj_2_$type - base_hcn_2
	drop base_hcn_1 base_hcn_2
	
	gen adj_mse =  sum((hcn_adj_1_$type - hcn_adj_2_$type) ^ 2) / _N
	keep if _n == _N
	keep adj_mse
	gen dataset = "$type"
	gen hcn_id_1 = `station_id_1'
	gen hcn_id_2 = `station_id_2'
	gen pair_id = `pair_id'
	gen distance = `distance'
	gen type = "adj"
	
	append using "`results'"
	save "`results'", replace
	}
	display `pair_id'
}

use "`results'", clear
save "hcn_only_adj_mse_diff $type $distance.dta", replace
